#include <mex.h>
#include "ctmf.h"

void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	int i, j, m, n, r;
	unsigned char *data1;
	unsigned char *data2;
	//double *dataOut;
	/* Error checking */
	if (nrhs != 2) mexErrMsgTxt("Usage: fast_medfilt(image,size).");
	/* Find the dimensions of the data */
	m = mxGetM(prhs[0]);
	n = mxGetN(prhs[0]);
	r = (int) *mxGetPr(prhs[1]); //size of the filter
	/* Create an mxArray for the output data */
	int dims[2] = {m,n};
	plhs[0] = mxCreateNumericArray(2, dims, mxUINT8_CLASS, mxREAL );//mxCreateDoubleMatrix(m, n, mxREAL);
	/* Retrieve the input data */
	data1 = (unsigned char*) mxGetPr(prhs[0]);
	/* Create a pointer to the output data */
	data2 = (unsigned char*) mxGetPr(plhs[0]);
	//dataOut = (double*) mxGetPr(plhs[0]);
	ctmf((unsigned char*) data1, (unsigned char*) data2, m,n,m*sizeof(unsigned char),m*sizeof(unsigned char), r, 1, 512*1024);
	/* Put data in the output array after squaring them */
	/*for (j = 0; j < m*n; j++)
	{
		dataOut[j] = (double) data2[j];
	}*/
}
